/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer;

import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorRoute;
import filenet.sim.toolkit.viewer.VWSIMAnimatorScenario;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.sim.toolkit.viewer.resources.VWSIMResource;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStepUtils;
import java.util.Vector;

public class VWSIMAnimatorStep {
    private VWSIMAnimatorScenario m_scenario = null;
    private VWSIMAnimatorWorkflow m_workflow = null;
    private VWSIMAnimatorMap m_map = null;
    private int m_mapId = -1;
    private String m_stepName = null;
    private int m_stepId = -1;
    private VWMapNode m_mapNode = null;
    private VWStepDefinition m_stepDefinition = null;
    private VWCompoundStepDefinition m_compoundStepDefinition = null;
    private VWSIMAnimatorMap m_mapCalled = null;
    private Vector m_prevRoutes = new Vector();
    private Vector m_nextRoutes = new Vector();
    private int m_completedCount = 0;
    private int m_activeCount = 0;
    private int m_overdueCount = 0;
    private double m_cost = 0.0;
    private double m_averageCost = 0.0;
    private long m_minProcessingTime = 0L;
    private long m_maxProcessingTime = 0L;
    private long m_aveProcessingTime = 0L;
    private long m_minCompletionTime = 0L;
    private long m_maxCompletionTime = 0L;
    private long m_aveCompletionTime = 0L;
    private long m_minWaitTime = 0L;
    private long m_maxWaitTime = 0L;
    private long m_aveWaitTime = 0L;

    public VWSIMAnimatorStep(VWSIMAnimatorMap map, VWMapNode mapNode) {
        this.m_map = map;
        if (map != null) {
            this.m_scenario = map.getScenario();
            this.m_workflow = map.getWorkflow();
            this.m_mapId = map.getMapId();
        }
        this.m_mapNode = mapNode;
        if (mapNode != null) {
            if (mapNode instanceof VWStepDefinition) {
                this.m_stepDefinition = (VWStepDefinition)mapNode;
            }
            if (mapNode instanceof VWCompoundStepDefinition) {
                this.m_compoundStepDefinition = (VWCompoundStepDefinition)mapNode;
                try {
                    VWInstructionDefinition[] instructions = this.m_compoundStepDefinition.getInstructions();
                    if (instructions != null) {
                        for (int i = 0; i < instructions.length; ++i) {
                            if (instructions[i].getAction() != 5) continue;
                            String mapName = VWInstruction.CallInstructionGetSubmap(instructions[i]);
                            this.m_mapCalled = this.m_workflow.getMap(mapName);
                            if (this.m_mapCalled == null) continue;
                            this.m_mapCalled.addCallingStep(this);
                        }
                    }
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
            }
            this.m_stepId = mapNode.getStepId();
            this.m_stepName = mapNode.getName();
        }
    }

    public VWSIMAnimatorScenario getScenario() {
        return this.m_scenario;
    }

    public void addPreviousRoute(VWSIMAnimatorRoute route) {
        this.m_prevRoutes.addElement(route);
    }

    public void addNextRoute(VWSIMAnimatorRoute route) {
        this.m_nextRoutes.addElement(route);
    }

    public Vector getPreviousRoutes() {
        return this.m_prevRoutes;
    }

    public Vector getNextRoutes() {
        return this.m_nextRoutes;
    }

    public VWMapNode getMapNode() {
        return this.m_mapNode;
    }

    public VWStepDefinition getStepDefinition() {
        return this.m_stepDefinition;
    }

    public VWCompoundStepDefinition getCompoundStepDefinition() {
        return this.m_compoundStepDefinition;
    }

    public String getStepName() {
        if ((this.m_stepName == null || this.m_stepName.trim().length() == 0) && this.m_stepId != -1) {
            this.m_stepName = VWSIMResource.s_blankLabel.toString(Integer.toString(this.m_stepId + 1));
        }
        return this.m_stepName;
    }

    public VWSIMAnimatorWorkflow getWorkflow() {
        return this.m_workflow;
    }

    public VWSIMAnimatorMap getMap() {
        return this.m_map;
    }

    public VWSIMAnimatorMap getSubmap() {
        if (this.isCallStep()) {
            return this.m_mapCalled;
        }
        return null;
    }

    public int getMapId() {
        return this.m_mapId;
    }

    public int getStepId() {
        return this.m_stepId;
    }

    public boolean isDummyStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 5 || stepType == 6;
    }

    public boolean isQueueStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 4 || stepType == 3;
    }

    public boolean isUserStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 2 || stepType == 1;
    }

    public boolean isComponentStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 13 || stepType == 14;
    }

    public boolean isCallStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 10 || stepType == 9;
    }

    public boolean isSystemStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 12 || stepType == 11;
    }

    public boolean isStartStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 10 || stepType == 6 || stepType == 8 || stepType == 4 || stepType == 12 || stepType == 2;
    }

    public String toString() {
        String str = this.getStepName();
        if (str != null) {
            return str;
        }
        return new String("");
    }

    public boolean isLaunchStep() {
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 0;
    }

    public synchronized int getCompletedCount() {
        return this.m_completedCount;
    }

    public synchronized int getActiveCount() {
        return this.m_activeCount;
    }

    public synchronized double getCost() {
        return this.m_cost;
    }

    public synchronized double getAverageCost() {
        return this.m_averageCost;
    }

    public synchronized int getOverdueCount() {
        return this.m_overdueCount;
    }

    public synchronized long getMinProcessingTime() {
        return this.m_minProcessingTime;
    }

    public synchronized long getMaxProcessingTime() {
        return this.m_maxProcessingTime;
    }

    public synchronized long getAverageProcessingTime() {
        return this.m_aveProcessingTime;
    }

    public synchronized long getMinCompletionTime() {
        return this.m_minCompletionTime;
    }

    public synchronized long getMaxCompletionTime() {
        return this.m_maxCompletionTime;
    }

    public synchronized long getMinWaitTime() {
        return this.m_minWaitTime;
    }

    public synchronized long getMaxWaitTime() {
        return this.m_maxWaitTime;
    }

    public synchronized long getAverageCompletionWaitTime() {
        return this.m_aveCompletionTime;
    }

    public synchronized long getAverageWaitTime() {
        return this.m_aveWaitTime;
    }

    public synchronized void setCompletedCount(int count) {
        this.m_completedCount = count;
    }

    public synchronized void setActiveCount(int count) {
        this.m_activeCount = count;
    }

    public synchronized void setCost(double cost) {
        this.m_cost = cost;
    }

    public synchronized void setAverageCost(double cost) {
        this.m_averageCost = cost;
    }

    public synchronized void setOverdueCount(int count) {
        this.m_overdueCount = count;
    }

    public synchronized void setMinProcessingTime(long time) {
        this.m_minProcessingTime = time;
    }

    public synchronized void setMaxProcessingTime(long time) {
        this.m_maxProcessingTime = time;
    }

    public synchronized void setAverageProcessingTime(long time) {
        this.m_aveProcessingTime = time;
    }

    public synchronized void setMinCompletionTime(long time) {
        this.m_minCompletionTime = time;
    }

    public synchronized void setMaxCompletionTime(long time) {
        this.m_maxCompletionTime = time;
    }

    public synchronized void setAverageCompletionTime(long time) {
        this.m_aveCompletionTime = time;
    }

    public synchronized void setMinWaitTime(long time) {
        this.m_minWaitTime = time;
    }

    public synchronized void setMaxWaitTime(long time) {
        this.m_maxWaitTime = time;
    }

    public synchronized void setAverageWaitTime(long time) {
        this.m_aveWaitTime = time;
    }

    public synchronized void complete() {
        ++this.m_completedCount;
        if (this.m_activeCount > 0) {
            --this.m_activeCount;
        }
    }

    public synchronized void enqueue() {
        ++this.m_activeCount;
    }

    public synchronized void clearStatistics() {
        this.m_completedCount = 0;
        this.m_activeCount = 0;
        this.m_cost = 0.0;
        this.m_averageCost = 0.0;
        this.m_overdueCount = 0;
    }

    void releaseResources() {
        this.m_scenario = null;
        this.m_workflow = null;
        this.m_map = null;
        this.m_mapId = -1;
        this.m_stepName = null;
        this.m_mapNode = null;
        this.m_stepDefinition = null;
        this.m_compoundStepDefinition = null;
        this.m_mapCalled = null;
        Object obj = null;
        if (this.m_prevRoutes != null) {
            this.m_prevRoutes.removeAllElements();
            this.m_prevRoutes = null;
        }
        if (this.m_nextRoutes != null) {
            this.m_nextRoutes.removeAllElements();
            this.m_nextRoutes = null;
        }
    }
}

